
markup.push({

// MARK: schedule item view

TimerView:		// one for each timer
{
	nsClass: "GXListItemView",	
	gxViewModel: { nsClass: "AH4TimerViewModel" },
	gxSelectable: 2, // multiselect
	gxDefaultValue: true,	// expanded
	axIsIgnored: false,
	axRoleDescription: "Schedule Timer",
	axValueKeyPath: "accessibilityDescription",	// not axDescriptionKeyPath, so value of 'expanded' is not read out for value
	axHelp: "Interact to configure the timer. Command-Delete to delete it.",
	gxBackPainter: "ListItemBack",
	gxLateLayout:
	[
		"V:|-(-999)-[self]",		// vertical position set by parent
		"H:|-10-[self]-2-|",

		"V:|-68-[divider(1)]-0-[advancedBtn(26)]-0-[advancedGroup]-0-|",
		"H:|-0-[divider]-0-|",

		"V:|-10-[status]-0-[dayDescription]-1-[timeDescription]",
		"V:|-11-[enabledSwitch]",

		"H:|-12-[status]-8-[enabledSwitch(52)]-10-|",
		"H:|-12-[dayDescription]-8-[enabledSwitch]",
		"H:|-12-[timeDescription]-8-[enabledSwitch]",
	],
	gxChildViews:
	{
		divider: {
			nsClass: "GXDrawView",
			gxBackPainter: fillPainter("BackColor2"),
		},
		enabledSwitch: {
			"+": "SwitchView.noBlockDisabled",
			axTitle: "timer enabled",
			gxValueKey: "enabled",
		},
		status: {
			"+": "LabelView.useMarkup.showAnimating.foreColor1.mediumWeight.left.size13",
			gxValueKey: "statusString",
			gxAnimateOnKey: "activeOrNear",
			gxDisableOnKey: "unscheduled",
			axIsIgnored: false,
        },
        dayDescription: {
            "+": "LabelView.useMarkup.left.foreColor1.size12",
            gxValueKey: "dayString",
            gxDisableOnKey: "unscheduled",
			axIsIgnored: false,
        },
		timeDescription: {
			"+": "LabelView.left.foreColor1.size12",
			gxValueKey: "timeString",
			gxDisableOnKey: "unscheduled",
			axIsIgnored: false,
		},
		advancedBtn: {
			"+": "AdvancedGroupButton.size12",
			gxLayout: [ "H:|-0-[self]-0-|" ],	// override default in template
			gxTitle: "<disclosure/> Settings",
			gxValueKey: "advancedExpanded",
			axFormatter: disclosureAxFormatter("Settings"),
			axHelp: "Reveals controls for scheduling this timer when expanded",
			gxForePainter: {
				"+": "AdvancedGroupButtonFore",
				gxEdgeInsets: "10, 0, 0, 0",
			},
            gxBackPainter: {
                "+": "ListItemBack",
                on: {
                    gxCornerRadii: "0, 0, 0, 0",
                },
                gxCornerRadii: "0, 0, 8, 8",
            },
		},
		advancedGroup:
		{
			nsClass: "GXExpandingView",
			gxDefaultValue: false, // collapsed
			//axIsIgnored: false,
			//axTitle: "Settings Group",
			gxValueKey: "advancedExpanded",
			gxCollapsedSize: 1,
			gxExtraSize: 10,
			gxLayout:
			[
				"H:|-0-[self]-0-|",
				
				"V:|-6-[mode]-11-[mon]-15-[from]-5-[quitSources]",
				
				"H:|-10-[mode]-10-|",
                "H:|-10-[mon]-10-[tue(==mon)]-10-[wed(==mon)]-10-[thu(==mon)]-10-[fri(==mon)]-10-[sat(==mon)]-10-[sun(==mon)]-10-|&alignBaseline",
             
			 	"H:|-10-[dateLabel(==fromLabel)]-5-[date]&alignBaseline",
			 	"H:|-10-[fromLabel(39)]-5-[from]-16-[toLabel]-5-[to]&alignBaseline",
                "H:|-10-[quitSources(180)]&alignBaseline",
			 			 
                "V:[date]-10-[from]",
			],
			gxChildViews:
			{
                mode: {
                    "+": "PopupMenuTemplate.listBack",
                    gxValueKey: "dateMode",
                    axTitle: "Type",
                    gxNextKeyView: "dateEditor",
                    gxMenuItems: [
                        { gxTitle: "On Date",	gxValue: 0 },
                        { gxTitle: "Repeat Every", gxValue: 1 }
                    ]
                },
                date: {
                    "+": "DatePickerView",
                    gxDatePickerType: 0,		// date picker
                    gxNextKeyView: "mon"
                },
				dateLabel: labelView("Date:"),
				mon: {	"+": "ScheduleDayButton", 	gxTitle: "Mon", gxValueKey: "repeatsOnDay_2", gxNextKeyView: "tue", axTitle: "Monday" },
                tue: {	"+": "ScheduleDayButton", 	gxTitle: "Tue", gxValueKey: "repeatsOnDay_3", gxNextKeyView: "wed", axTitle: "Tuesday" },
                wed: {	"+": "ScheduleDayButton", 	gxTitle: "Wed", gxValueKey: "repeatsOnDay_4", gxNextKeyView: "thu", axTitle: "Wednesday" },
                thu: {	"+": "ScheduleDayButton", 	gxTitle: "Thu", gxValueKey: "repeatsOnDay_5", gxNextKeyView: "fri", axTitle: "Thursday" },
                fri: {	"+": "ScheduleDayButton", 	gxTitle: "Fri", gxValueKey: "repeatsOnDay_6", gxNextKeyView: "sat", axTitle: "Friday" },
                sat: {	"+": "ScheduleDayButton", 	gxTitle: "Sat", gxValueKey: "repeatsOnDay_7", gxNextKeyView: "sun", axTitle: "Saturday" },
                sun: {	"+": "ScheduleDayButton",	gxTitle: "Sun", gxValueKey: "repeatsOnDay_1", gxNextKeyView: "from", axTitle: "Sunday" },
                from: {
                    "+": "DatePickerView",
                    gxDatePickerType: 1,		// time picker
                    gxValueKey: "startTime",
                    gxNextKeyView: "to",
                    axTitle: "From time"
                },
				fromLabel: labelView("From:"),
                to: {
                    "+": "DatePickerView",
                    gxDatePickerType: 1,		// time picker
                    gxValueKey: "endTime",
                    gxNextKeyView: "mode",
                    axTitle: "To time"
                },
				toLabel: labelView("To:"),
                quitSources: {
                    "+": "CheckboxTemplate.listBack",
                    gxTitle: "<checkbox/> Quit sources when done",
                    gxValueKey: "quitSources",
					gxButtonType: "checkbox",
                    axTitle: "Quit sources when done"
                }
			}
		}
	}
},

DatePickerView: {
	nsClass: "GXDatePicker",
	pickerType: 0,	// 0 = date, 1 = time, 2 = duration
	gxHideOnNilValue: true,
	gxForePainter: "ControlFore",
	gxBackPainter: {
		"+": "ControlBack.listBack",
		gxEdgeInsets: "0, 0, 18, 4",
	},
	gxLabelTemplate: "LabelView.right.size13"
},

ScheduleDayButton: {
	"+": "ButtonView.size11",
    gxIntrinsicHeight: 24,
	gxBackPainter:
    {
        "+": "ControlBack.listBack",
        gxCornerRadius: 999,
    },
	gxHideOnNilValue: true,
    gxButtonType: "checkbox",
},


})
